//
//  psCharstrings.h
//  GSFontTools
//
//  Created by Georg Seifert on 31.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class CFFPrivateDict;
@class CFFGlobalSubrsIndex;
@class CFFSubrsIndex;
@class GSFileData;
@class CFFIndexedStrings;
@class GSFileData;
@class GSXMLWriter;
@class OTBasePen;

@interface ByteCodeBase : NSObject {
	NSArray *_operandEncoding;
	NSDictionary *_operators;
}

@property (readonly, nonatomic) NSDictionary *operators;

- (id)do_operator:(NSUInteger)b0 file:(NSData *)data pos:(NSUInteger *)pos;

//- (NSNumber*)read_byte:(NSInteger)b0 file:(GSFileData*)file;
//- (NSNumber*)read_smallInt1:(NSInteger)b0 file:(GSFileData*)file;
//- (NSNumber*)read_smallInt2:(NSInteger)b0 file:(GSFileData*)file;
//- (NSNumber*)read_shortInt:(NSInteger)b0 file:(GSFileData*)file;
//- (NSNumber*)read_longInt:(NSInteger)b0 file:(GSFileData*)file;
//- (NSNumber*)read_fixed1616:(NSInteger)b0 file:(GSFileData*)file;
//- (NSNumber*)read_realNumber:(NSInteger)b0 file:(GSFileData*)file;
@end

@interface psT2CharString : ByteCodeBase {
	NSMutableArray *_program;
	NSData *_bytecode;
	CFFPrivateDict *_private;
	CFFGlobalSubrsIndex *_globalSubrs;
	NSInteger _width;
}

@property (nonatomic, retain) NSMutableArray *program;
@property (nonatomic, retain) NSData *bytecode;
@property (nonatomic, retain) CFFPrivateDict *private;
@property (nonatomic, retain) CFFGlobalSubrsIndex *globalSubrs;
@property (nonatomic, assign) NSInteger width;

- (id)initWithBytecode:(NSData *)byteCode private:(CFFPrivateDict *)private globalSubrs:(CFFGlobalSubrsIndex *)globalSubrs;

//- (id)initWithFile:(GSFileData*)file private:(PrivateDict*)private  globalSubrs:(GlobalSubrsIndex*)globalSubrs;

- (void)toXML:(GSXMLWriter *)writer;

- (void)fromXML:(NSString *)name attrs:(NSDictionary *)attrs content:(id)content;

- (BOOL)needsDecompilation;
@end

@interface psT1CharString : psT2CharString
@end

@interface psDictDecompiler : ByteCodeBase {
	// id _operators;
	CFFIndexedStrings *_strings;
	NSMutableDictionary *_dict;
	NSMutableArray *_stack;
}

- (void)decompile:(NSData *)file;

- (id)initWithStrings:(id)strings;

- (id)dict;

- (void)handleOperator:(NSString *)operator argType:(id)argType;
@end

@interface psSimpleT2Decompiler : NSObject {
	CFFSubrsIndex *_localSubrs;
	NSUInteger _localBias;
	CFFGlobalSubrsIndex *_globalSubrs;
	NSUInteger _globalBias;
	NSMutableArray *_callingStack;
	NSMutableArray *_operandStack;
	NSUInteger _hintCount;
	NSUInteger _hintMaskBytes;
}

@property (nonatomic, retain) CFFSubrsIndex *localSubrs;
@property (nonatomic) NSUInteger localBias;
@property (nonatomic, retain) id globalSubrs;
@property (nonatomic) NSUInteger globalBias;
@property (nonatomic, retain) NSMutableArray *callingStack;

- (void)addToCallingStack:(id)_callingStackObject;

- (void)removeFromCallingStack:(id)_callingStackObject;

@property (nonatomic, retain) NSMutableArray *operandStack;
@property (nonatomic) NSUInteger hintCount;
@property (nonatomic) NSUInteger hintMaskBytes;

- (id)initWithLocalSubrs:(CFFSubrsIndex *)localSubrs globalSubrs:(CFFGlobalSubrsIndex *)globalSubrs;

- (void)execute:(psT2CharString *)charstring;
@end

@interface psT2OutlineExtractor : psSimpleT2Decompiler {
	OTBasePen *_pen;
	NSUInteger _nominalWidthX;
	NSUInteger _defaultWidthX;
	NSMutableArray *_hints;
	BOOL _gotWidth;
	NSInteger _width;
	NSPoint _currentPoint;
	BOOL _sawMoveTo;
}

@property (nonatomic, retain) OTBasePen *pen;
@property (nonatomic, retain) NSMutableArray *hints;
@property (nonatomic) NSInteger width;

- (id)initWithPen:(OTBasePen *)pen localSubrs:(CFFSubrsIndex *)localSubrs globalSubrs:(CFFGlobalSubrsIndex *)globalSubrs nominalWidthX:(int)nominalWidthX defaultWidthX:(int)defaultWidthX;
@end

@interface psT1OutlineExtractor : psT2OutlineExtractor {
	id _subrs;
	BOOL _flexing;
	int _sbx;
}

@property (nonatomic, retain) id subrs;
@property (nonatomic) BOOL flexing;
@property (nonatomic) int sbx;
@end
